# Vibe Coding 幻觉和死循环处理

> 如何让失控的 AI 重回正轨



你好，我是鱼皮。

在前面的文章里，我们讲了如何和 AI 高效对话，如何管理上下文。但即使你做得再好，也难免会遇到 AI 罢工的情况 —— 它开始胡说八道、陷入死循环、或者固执地坚持错误的方案。

这种情况在 Vibe Coding 中很常见，我们称之为 AI 幻觉（AI Hallucination）。下面我会教你如何识别和修复这些问题，让失控的 AI 重回正轨。




## 一、什么是 AI 幻觉？

在讲解决方法之前，我们先要理解什么是 AI 幻觉。



### AI 幻觉的定义

AI 幻觉指的是 AI 生成的内容看起来很有道理，但实际上是错误的、不存在的，或者不符合事实的。

比如下面这段对话，我的本名可不是这个……

![](https://pic.yupi.icu/1/image-20260104184328898.png)

在编程场景中，AI 幻觉通常表现为：

- 编造不存在的 API 或函数
- 给出看似合理但实际无法运行的代码
- 坚持使用已经被证明错误的方案
- 混淆不同技术栈的用法

举个例子，你问 AI：React 中如何获取组件的 DOM 节点？

AI 可能会告诉你用 `this.getDOMNode()`。

这个方法听起来很合理，但实际上在现代 React 中并不存在，正确的做法是用 `useRef`。




### 为什么会产生幻觉？

AI 产生幻觉的原因有几个：

1. 训练数据的局限：AI 的知识来自训练数据，如果数据中有错误或过时的信息，AI 就会学到错误的知识。

2. 上下文混淆：当对话太长或信息太杂时，AI 可能会混淆不同的上下文。

3. 过度自信：AI 被训练成要给出 “确定” 的答案，即使它不确定，也会表现得很自信。

4. 模式匹配错误：AI 可能会把相似但不同的概念混在一起。

理解了这些原因，我们就能更好地应对幻觉问题。



### 扩展知识 - AI 幻觉的常见类型

在 Vibe Coding 中，AI 幻觉主要有这几种类型：

1. API 幻觉：编造不存在的函数、方法或属性

2. 语法幻觉：混淆不同语言或框架的语法

3. 逻辑幻觉：代码逻辑看起来对，但实际上有问题

4. 版本幻觉：使用已废弃的 API 或过时的写法

5. 依赖幻觉：引用不存在的库或错误的包名

了解这些类型，能帮你快速识别问题。



## 二、AI 陷入死循环的表现

除了幻觉，AI 还有一个常见问题：陷入死循环。



### 什么是死循环？

死循环指的是 AI 反复尝试同一个错误的方案，无法自己跳出来。

典型的表现是：

- 第一次：AI 给你一段代码，但有 bug。
- 第二次：你告诉它有问题，它改了一下，但还是同样的问题。
- 第三次：你再次指出问题，它又改了一下，但还是在同一个地方打转。
- 第四次：你开始怀疑人生……

这就是死循环，AI 被困在了一个错误的思路里，无法自己走出来。不仅浪费时间，还白白浪费了大量 tokens。

![](https://pic.yupi.icu/1/aideadloop%E5%A4%A7.jpeg)



### 死循环的常见场景

死循环经常出现在这些场景：

1. 复杂的状态管理：AI 在处理复杂的状态更新时容易混乱

2. 异步操作：涉及 Promise、async/await 时容易出错

3. 类型系统：TypeScript 的复杂类型定义容易让 AI 困惑

4. 性能优化：AI 可能会陷入 “优化 => 出错 => 回退 => 再优化” 的循环

5. 跨文件修改：修改多个文件时容易顾此失彼，尤其是项目文件较多的时候



### 怎么识别死循环？

我个人识别死循环的一些信号：

- AI 连续 3 次给出的方案本质上是一样的
- 每次修改只是换了个写法，但核心问题没解决
- AI 开始道歉，并说 “让我重新尝试”
- 你发现自己在重复说同样的问题

一旦发现这些信号，就要立刻打断，不要继续下去。




## 三、如何切断上下文并重新开始

当 AI 陷入死循环或产生严重幻觉时，最有效的方法就是切断上下文，重新开始。




### 为什么要切断上下文？

继续在混乱的上下文中对话，就像在泥潭里越陷越深。AI 会被之前的错误信息影响，很难给出正确的答案。

切断上下文相当于给 AI 一个重启的机会，让它从干净的状态开始。




### 切断的正确方法

不要直接开一个空白对话就开始问问题。正确的方法是：

1）总结当前的问题

在新对话开始前，先整理一下：
- 你想实现什么功能
- 已经尝试了哪些方案
- 遇到了什么具体问题
- 当前的代码状态



2）开始新对话

在新对话中，先提供完整的上下文：

```markdown
我在开发一个博客系统，技术栈是 Next.js 16 + TypeScript + Supabase。
我想实现文章的自动保存功能，但遇到了问题。
我尝试过用 useEffect 监听内容变化，但会导致频繁保存。我也试过用 debounce，但有时候会丢失数据。
这是我当前的代码：【贴上相关代码】
请帮我分析问题并给出解决方案。
```



3）明确要求不同的思路

告诉 AI 之前的方案不行，要换个思路：

```markdown
之前的方案都有问题，请给我一个完全不同的实现思路。
```

这样 AI 就不会重复之前的错误。

或者先利用其他的 AI 模型给出不同的方案，再直接把方案贴给 AI 让它执行。




### 什么时候应该切断？

不是所有问题都需要切断上下文。如果只是小问题，在当前对话中纠正就行。但如果遇到这些情况，就要果断切断：

- 对话轮数太多了（超过 20 轮），上下文已经很长，继续下去只会更费钱更混乱
- AI 开始混淆概念了，比如把你的技术栈搞错，或者把不同功能的代码混在一起
- 你自己都觉得乱了，说不清楚当前的状态，这时候继续下去只会越来越乱
- 还有前面提到的 “死循环” 情况

简单来说，当你发现对话已经失控了，就该切断。与其在泥潭里挣扎，不如重新开始。




## 四、如何给 AI 喂入报错信息

很多时候，AI 生成的代码有 bug，但它不知道。这时候，你需要把报错信息准确地喂给它。




### 完整复制错误信息

不要只说 "代码报错了" 或者 "不工作"，而是要把完整的错误信息复制给 AI。

❌ 不好的反馈：你的代码有问题，运行不了。

✅ 好的反馈：

```markdown
代码运行时报错了，错误信息如下：
TypeError: Cannot read property 'map' of undefined
    at NoteList (NoteList.tsx:15)
    at renderWithHooks (react-dom.development.js:14985)
这是第 15 行的代码：
{notes.map(note => <NoteItem key={note.id} note={note} />)}
```

完整的错误信息能让 AI 快速定位问题。




### 提供上下文代码

除了错误信息，还要提供相关的代码上下文。

```markdown
这是出错的组件完整代码，错误发生在第 9 行：
export function NoteList() {
  const [notes, setNotes] = useState();
  
  useEffect(() => {
    fetchNotes().then(data => setNotes(data));
  }, []);
  
  return (
    <div>
      {notes.map(note => <NoteItem key={note.id} note={note} />)}
    </div>
  );
}
```

这样 AI 就能看到完整的上下文，给出准确的修复方案。




### 说明复现步骤

如果是和用户交互相关的 bug，要说明如何复现。

```markdown
这个错误只在特定情况下出现：

1. 用户首次进入页面时正常
2. 点击 '刷新' 按钮后正常
3. 但如果用户先删除一条笔记，再点击"刷新"，就会报错

错误信息是：【贴上错误信息】
```

毕竟 AI 是看不到用户动作的，详细的复现步骤能帮助 AI 理解问题的本质。




### 使用浏览器控制台

如果是网页的前端出现了问题，那么一定要利用好浏览器控制台。

按 F12 打开开发者工具，切换到 Console 控制台标签，你会看到：

- 错误信息（红色）
- 警告信息（黄色）
- 日志信息（白色）

把这些信息截图或复制给 AI，它能更快地找到问题。

![](https://pic.yupi.icu/1/image-20260104190230437.png)

如果你不知道是不是前端出了问题，或者根本不知道什么是前端，那大概率就是前端出了问题。




## 五、判断问题来源

有时候，问题不在 AI，而在你的需求或逻辑本身。

如果是 AI 的问题，一般有这些特征：

- 代码语法错误或无法运行
- 使用了不存在的 API
- 逻辑明显不符合你的描述
- 代码风格和之前的完全不一致

这些问题可以通过更好的提示或切断上下文来解决。

但如果是逻辑问题，一般有这些特征：

- 代码能运行，但结果不对
- 边界情况没有处理
- 性能有问题
- 用户体验不好

这些问题需要你重新思考需求，而不是盲目责怪 AI。



### 怎么判断问题来源？

一个简单的方法是问自己：如果我把这个需求给一个真人开发者，他能做对吗？

如果答案是 “不确定” 或者 “可能也会有问题”，那很可能是需求本身不够清晰。

这时候，你需要先：

1. 重新梳理需求
2. 明确边界条件
3. 画出流程图或状态图
4. 写出详细的测试用例

然后再和 AI 讨论实现方案。

有同学说：我怎么知道真人开发者能不能做对啊？！

这其实也是缺少专业知识的问题，如果你本身懂技术，会更好地驾驭 AI 和判断问题。即使你不知道这个问题的答案，也可以试着换种方式描述你的需求，或者借助其他 AI 来润色需求、帮你做判断。




## 六、实战案例：修复失控的项目

让我用一个真实的案例，展示如何修复一个失控的项目。



### 场景描述

你在做一个待办事项应用，想实现拖拽排序功能。你和 AI 对话了十几轮，但功能还是不对：

- 第一次：AI 用了一个不存在的库
- 第二次：改用了 react-beautiful-dnd，但代码报错
- 第三次：修复了报错，但拖拽后数据没有更新
- 第四次：数据更新了，但界面没有刷新
- 第五次：界面刷新了，但顺序不对
- 你开始怀疑人生……

接下来你会怎么做呢？



### 1、暂停并分析

不要继续下去了！先暂停，分析一下问题：

- 核心问题是什么？（拖拽排序）
- 为什么一直不对？（可能是 AI 对状态管理理解有误）
- 有没有更简单的方案？（也许不需要用库）



### 2、切断上下文

开一个新对话，但这次换个方式问：

```markdown
我想实现一个简单的拖拽排序功能。不要用第三方库，用原生的 HTML5 Drag and Drop API
需求：
1. 用户可以拖动列表项
2. 拖动时显示占位符
3. 放下时更新顺序
4. 数据用 useState 管理
请先给我一个最简单的实现，只要能拖动就行，不需要动画。
```




### 3、逐步完善

AI 给了一个简单的版本，你测试后发现能用，爽爽爽。

然后再逐步添加功能：

1. 很好，现在加上拖动时的视觉反馈：被拖动的项半透明。
2. 再加上占位符：拖动时在目标位置显示一个虚线框。
3. 最后加上平滑的动画效果。

每一步都很小，每一步都能测试，这样就不会失控。




### 4、总结经验

问题解决后，让 AI 帮你总结：

```markdown
我们刚才实现了拖拽排序功能。请总结一下：
1. 为什么之前的方案不行？
2. 这个方案的关键点是什么？
3. 如果以后要实现类似功能，应该注意什么？
```

这些总结可以加入你的项目文档，避免以后重复踩坑。



## 七、预防幻觉的技巧

除了修复问题，我们还可以提前预防。



### 1、要求 AI 解释

不要盲目接受 AI 的答案，让它解释为什么这样做。

- 你为什么选择用 useCallback 而不是 useMemo？
- 这个方案的优缺点是什么？
- 有没有其他实现方式？

通过解释，你能发现 AI 是否真的理解了问题。



### 2、要求提供文档链接

如果 AI 提到了某个 API 或库，让它提供官方文档链接。

```markdown
你提到了 react-query 的 useInfiniteQuery，能给我官方文档的链接吗？
```

如果 AI 给不出链接，或者链接是错的，那这个 API 可能是它编造的。



### 3、分步验证

不要一次性实现整个功能，而是分步验证。

- 先帮我实现最核心的部分，其他的暂时用假数据
- 这一步能运行了，我们再做下一步

小步快跑，每一步都验证，能及早发现问题。



### 4、使用类型系统

建议在项目中使用 TypeScript 技术，它是一种给 JavaScript 加上类型检查的编程语言，可以充分利用它的类型系统来预防问题。

什么是类型系统？

简单来说，就是给每个变量、函数都标注清楚它是什么类型的数据。比如这个变量是数字、那个变量是字符串、这个函数返回的是用户对象等等。有了这些标注，编辑器就能在你写代码时就发现问题，而不是等到运行时才报错。

看个例子：

```ts
// ❌ 没有类型定义：AI 可能生成错误的代码
function calculateTotal(items) {
  return items.reduce((sum, item) => sum + item.price, 0);
}

// 如果传入的数据格式不对，只有运行时才会报错
calculateTotal([{ name: '商品' }]); // 运行时报错：price is undefined

// ✅ 有类型定义：编辑器立刻提示错误
interface Item {
  name: string;
  price: number;
}

function calculateTotal(items: Item[]): number {
  return items.reduce((sum, item) => sum + item.price, 0);
}

// 编辑器会立刻用红色波浪线提示：缺少 price 属性
calculateTotal([{ name: '商品' }]); // 编写时就发现错误
```

如果生成的项目比较复杂，AI 应该会默认使用 TypeScript 技术。你也可以主动要求 AI：请给所有函数和组件加上完整的 TypeScript 类型定义。

这样，如果 AI 生成的代码有类型不匹配的问题，编辑器会立刻用红色波浪线提示你，你就能马上发现并修复。这比等到运行时才发现问题要高效得多。



### 5、写测试

让 AI 帮你写测试用例：

```markdown
请为这个函数写单元测试，覆盖正常情况和边界情况。
```

测试能帮你发现逻辑问题。



### 6、让 AI 自主验证工作

不要光让 AI 干活，还要让它知道怎么验证自己的工作。

比如在开发 Web 应用时，可以让 AI 打开浏览器来测试 UI，发现问题后自动迭代，直到功能正常运行。这样能形成一个自动化的反馈循环：

```markdown
请实现这个功能，并且在完成后自动打开浏览器测试。如果发现问题，请自动修复并重新测试，直到功能正常工作。
```

这种方式能让 AI 更自主地工作，减少人工干预，特别适合处理需要多次迭代的任务，也是 Claude Code 创始人强烈建议的技巧。



## 八、常见幻觉场景和应对方法

基于我的经验，这里总结了一些常见的幻觉场景和应对方法。



### 场景一：编造的 API

表现：AI 使用了一个听起来很合理，但实际不存在的 API。

应对：

```markdown
这个 API 在官方文档中找不到，你确定它存在吗？请给我文档链接。
```

如果 AI 承认错误，让它给出正确的 API：

```markdown
那正确的做法是什么？请用官方推荐的方式实现。
```




### 场景二：过时的写法

表现：AI 使用了已废弃的 API 或旧版本的写法。

应对：

```markdown
这个写法是旧版本的。我用的是 React 19，请用最新的写法。
```

然后明确要求：

```markdown
请用 Hooks 而不是 Class 组件。
```



### 场景三：混淆技术栈

表现：AI 把不同框架的用法混在一起。

应对：

```markdown
等等，你给的是 Vue 的写法，我用的是 React。请用 React 的方式重写。
```

然后重新强调技术栈：

```markdown
我的项目用的是 React 19 + TypeScript，请确保代码符合这个技术栈。
```



### 场景四：逻辑漏洞

表现：代码能运行，但有明显的逻辑问题。

应对：

```markdown
这个方案有问题：如果用户在加载过程中关闭页面，数据会丢失。请考虑这个边界情况。
```

然后要求改进：

```markdown
请加上错误处理和数据持久化。
```



### 场景五：性能问题

表现：代码能用，但性能很差。

应对：

```markdown
这个方案在数据量大时会很慢。请优化性能，比如用虚拟滚动或分页。
```

然后要求分析：

```markdown
请分析一下这个方案的时间复杂度，并给出优化建议。
```



## 写在最后

AI 幻觉和死循环是 Vibe Coding 中不可避免的问题，但它们并不可怕。只要你掌握了正确的应对方法，就能快速解决。

让我总结一下本文的要点：

1. 理解幻觉的本质：AI 不是故意犯错，而是受限于训练数据和上下文。

2. 识别死循环信号：连续三次相同的错误方案，就要警惕了。

3. 勇于切断上下文：不要在泥潭里越陷越深，及时重新开始。

4. 提供完整信息：错误信息、代码上下文、复现步骤都要给 AI。

5. 区分问题来源：判断是 AI 的问题还是逻辑的问题。

6. 预防胜于治疗：通过解释、验证、测试来提前发现问题。

记住，AI 是你的助手，不是魔法。它会犯错，但只要你掌握了调试的方法，就能让它成为可靠的伙伴。

下一篇文章，我会讲解 Vibe Coding 的效率提升技巧，教你如何用快捷键、模板、自动化等方式提高开发效率。

加油小伙伴！💪




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
